/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.ModTabs;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IJamConfig;
import dev.toma.gunsrpg.api.common.IReloadManager;
import dev.toma.gunsrpg.api.common.IWeaponConfig;
import dev.toma.gunsrpg.api.common.attribute.IAttributeId;
import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.client.animation.BulletEjectAnimation;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.common.IShootProps;
import dev.toma.gunsrpg.common.attribute.Attribs;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.entity.projectile.Bullet;
import dev.toma.gunsrpg.common.entity.projectile.PenetrationData;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.common.item.guns.ammo.IMaterialData;
import dev.toma.gunsrpg.common.item.guns.ammo.IMaterialDataContainer;
import dev.toma.gunsrpg.common.item.guns.reload.ReloadManagers;
import dev.toma.gunsrpg.common.item.guns.setup.AbstractGun;
import dev.toma.gunsrpg.common.item.guns.setup.MaterialContainer;
import dev.toma.gunsrpg.common.item.guns.setup.WeaponBuilder;
import dev.toma.gunsrpg.common.item.guns.setup.WeaponCategory;
import dev.toma.gunsrpg.common.item.guns.util.Firemode;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.util.properties.Properties;
import dev.toma.gunsrpg.util.properties.PropertyContext;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.Easings;
import lib.toma.animations.api.AnimationList;
import lib.toma.animations.api.IAnimationEntry;
import lib.toma.animations.api.IRenderConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class GunItem
extends AbstractGun
implements IAnimationEntry {
    private final WeaponCategory weaponCategory;
    private final IWeaponConfig config;
    private final MaterialContainer container;
    private final AmmoType ammoType;
    private final BiFunction<PlayerEntity, Firemode, Firemode> firemodeSelector;

    public GunItem(String name, Item.Properties properties) {
        super(name, properties.func_200916_a(ModTabs.WEAPON_TAB));
        WeaponBuilder builder = new WeaponBuilder();
        this.initializeWeapon(builder);
        builder.validate();
        this.weaponCategory = builder.getWeaponCategory();
        this.config = builder.getConfig();
        this.container = builder.getMaterialContainer();
        this.ammoType = builder.getAmmoType();
        this.firemodeSelector = builder.getFiremodeSelector();
    }

    public abstract void initializeWeapon(WeaponBuilder var1);

    public abstract SkillType<?> getRequiredSkill();

    protected int getUnjamTime(ItemStack stack) {
        return 20;
    }

    public float getWeaponDamage(ItemStack stack, LivingEntity shooter) {
        IWeaponConfig config = this.getWeaponConfig();
        float base = config.getDamage();
        float damageMultiplier = 1.0f;
        if (shooter instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)shooter;
            IPlayerData data = PlayerData.getUnsafe(player);
            IAttributeProvider provider = data.getAttributes();
            IAttributeId attributeId = this.isSilenced(player) ? Attribs.SILENT_WEAPON_DAMAGE : Attribs.LOUD_WEAPON_DAMAGE;
            damageMultiplier = provider.getAttribute(attributeId).floatValue();
            WeaponCategory category = this.getWeaponCategory();
            if (category.hasBonusDamage()) {
                IAttributeId categoryId = category.getBonusDamageAttribute();
                damageMultiplier *= provider.getAttribute(categoryId).floatValue();
            }
        }
        return damageMultiplier * (base + (float)this.getDamageBonus(stack));
    }

    public int getMaxAmmo(IAttributeProvider provider) {
        return 1;
    }

    public int getReloadTime(IAttributeProvider provider, ItemStack stack) {
        return provider.getAttribute(Attribs.RELOAD_SPEED).intValue();
    }

    public int getFirerate(IAttributeProvider provider) {
        return 1;
    }

    public float getVerticalRecoil(IAttributeProvider provider) {
        return provider.getAttribute(Attribs.RECOIL_CONTROL).floatValue();
    }

    public float getHorizontalRecoil(IAttributeProvider provider) {
        return provider.getAttribute(Attribs.RECOIL_CONTROL).floatValue();
    }

    public double getNoiseMultiplier(IAttributeProvider provider) {
        return provider.getAttributeValue(Attribs.WEAPON_NOISE);
    }

    public double getHeadshotMultiplier(IAttributeProvider provider) {
        return provider.getAttributeValue(Attribs.HEADSHOT_DAMAGE);
    }

    public final boolean switchFiremode(ItemStack stack, PlayerEntity player) {
        Firemode firemode = this.getFiremode(stack);
        Firemode next = this.firemodeSelector.apply(player, firemode);
        if (next != firemode) {
            this.setFiremode(stack, next);
            return true;
        }
        return false;
    }

    public float modifyProjectileDamage(AbstractProjectile projectile, LivingEntity entity, PlayerEntity shooter, float damage) {
        return damage;
    }

    public void onHitEntity(AbstractProjectile bullet, LivingEntity victim, ItemStack stack, LivingEntity shooter) {
    }

    public void onKillEntity(AbstractProjectile bullet, LivingEntity victim, ItemStack stack, LivingEntity shooter) {
    }

    protected SoundEvent getShootSound(PlayerEntity entity) {
        return SoundEvents.field_187750_dc;
    }

    protected SoundEvent getEntityShootSound(LivingEntity entity) {
        return SoundEvents.field_187750_dc;
    }

    public IReloadManager getReloadManager(PlayerEntity player, IAttributeProvider attributeProvider) {
        return ReloadManagers.fullMagLoading();
    }

    public void shootProjectile(World level, LivingEntity shooter, ItemStack stack, IShootProps props) {
        Integer tracer;
        AbstractProjectile projectile = this.makeProjectile(level, shooter);
        PropertyContext context = props.getExtraData();
        projectile.addProperties(context);
        IWeaponConfig config = this.getWeaponConfig();
        float damage = this.getWeaponDamage(stack, shooter) * props.getDamageMultiplier();
        float velocity = this.getInitialVelocity(config, shooter);
        int delay = config.getGravityDelay();
        projectile.setup(damage, velocity, delay);
        projectile.fire(shooter.field_70125_A, shooter.field_70177_z, this.getInaccuracy(props, shooter));
        this.prepareForShooting(projectile, shooter);
        IAmmoMaterial material = this.getMaterialFromNBT(stack);
        if (material != null && (tracer = material.getTracerColor()) != null) {
            projectile.setProperty(Properties.TRACER, tracer);
        }
        if (shooter instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)shooter;
            PlayerData.get(player).ifPresent(data -> {
                PenetrationData penetrationData = this.getPenetrationData((IPlayerData)data);
                if (penetrationData != null) {
                    projectile.setProperty(Properties.PENETRATION, penetrationData);
                }
            });
        }
        level.func_217376_c((Entity)projectile);
    }

    protected float getInaccuracy(IShootProps props, LivingEntity entity) {
        return props.getInaccuracy();
    }

    protected float getInitialVelocity(IWeaponConfig config, LivingEntity shooter) {
        return config.getVelocity();
    }

    protected AbstractProjectile makeProjectile(World level, LivingEntity shooter) {
        return new Bullet((EntityType<? extends Bullet>)((EntityType)ModEntities.BULLET.get()), level, shooter);
    }

    protected void prepareForShooting(AbstractProjectile projectile, LivingEntity shooter) {
    }

    public final int getUnjamTime(ItemStack stack, IAttributeProvider provider) {
        return (int)((double)this.getUnjamTime(stack) * provider.getAttributeValue(Attribs.UNJAMMING_SPEED));
    }

    public final IWeaponConfig getWeaponConfig() {
        return this.config;
    }

    public final SoundEvent getWeaponShootSound(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return this.getShootSound((PlayerEntity)entity);
        }
        return this.getEntityShootSound(entity);
    }

    public final void shoot(World world, LivingEntity entity, ItemStack stack, IShootProps props) {
        this.shoot(world, entity, stack, props, this.getWeaponShootSound(entity));
    }

    public final void shoot(World world, LivingEntity entity, ItemStack stack, IShootProps props, SoundEvent event) {
        if (stack.func_77952_i() >= stack.func_77958_k()) {
            GunsRPG.log.warn("{} has tried to shoot with weapon which has no durability", (Object)entity.func_200200_C_().getString());
            return;
        }
        this.handleShootProjectileAction(world, entity, stack, props);
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            IPlayerData data = PlayerData.getUnsafe((PlayerEntity)player);
            IAttributeProvider attributeProvider = data.getAttributes();
            Random random = world.func_201674_k();
            AmmoType type = this.getAmmoType();
            IAmmoMaterial material = this.getMaterialFromNBT(stack);
            IMaterialDataContainer container = type.getContainer();
            IWeaponConfig config = this.getWeaponConfig();
            IJamConfig jamConfig = config.getJamConfig();
            float baseJamChance = jamConfig.getJamChance(stack);
            float playerJamChanceMultiplier = this.getModifiedJamChance(attributeProvider.getAttribute(Attribs.JAM_CHANCE).floatValue(), data);
            float damageChance = this.getModifiedDamageChance(attributeProvider.getAttribute(Attribs.WEAPON_DURABILITY).floatValue(), data);
            if (container != null) {
                IMaterialData materialData = container.getMaterialData(material);
                float ammoJamChanceMultiplier = materialData.getAddedJamChance();
                playerJamChanceMultiplier += ammoJamChanceMultiplier;
                damageChance *= 1.0f - materialData.getAddedDurability();
            }
            if (!GunsRPG.config.weapon.disableWeaponDurability) {
                if (damageChance < 1.0f) {
                    if (random.nextFloat() < damageChance) {
                        stack.func_96631_a(1, random, player);
                    }
                } else {
                    int amount = 1;
                    if (random.nextFloat() < damageChance - 1.0f) {
                        amount = Math.min(stack.func_77958_k() - stack.func_77952_i(), 2);
                    }
                    stack.func_96631_a(amount, random, player);
                }
            }
            float jamChance = baseJamChance * playerJamChanceMultiplier;
            if (random.nextFloat() <= jamChance) {
                this.setJammedState(stack, true);
            }
        }
        if (this.consumeAmmo(stack, entity)) {
            int ammo = this.getAmmo(stack);
            this.setAmmoCount(stack, ammo - 1);
        }
        world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), event, SoundCategory.MASTER, this.getWeaponSoundVolume(entity), 1.0f);
    }

    public final AmmoType getAmmoType() {
        return this.ammoType;
    }

    public final WeaponCategory getWeaponCategory() {
        return this.weaponCategory;
    }

    public final Set<IAmmoMaterial> getCompatibleMaterials() {
        return this.container.getCompatible();
    }

    @Override
    public final MaterialContainer getContainer() {
        return this.container;
    }

    protected void handleShootProjectileAction(World world, LivingEntity entity, ItemStack stack, IShootProps props) {
        this.shootProjectile(world, entity, stack, props);
    }

    protected float getWeaponSoundVolume(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            return this.isSilenced(player) ? 3.0f : 15.0f;
        }
        return 15.0f;
    }

    protected boolean isSilenced(PlayerEntity player) {
        return false;
    }

    protected boolean consumeAmmo(ItemStack stack, LivingEntity consumer) {
        return true;
    }

    protected float getModifiedDamageChance(float damageChance, IPlayerData data) {
        return damageChance;
    }

    protected float getModifiedJamChance(float jamChance, IPlayerData data) {
        return jamChance;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract ResourceLocation getReloadAnimation(PlayerEntity var1);

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getAimAnimationPath(ItemStack stack, PlayerEntity player) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getBulletEjectAnimationPath() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getUnjamAnimationPath() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onShoot(PlayerEntity player, ItemStack stack) {
        ResourceLocation bulletEjectPath = this.getBulletEjectAnimationPath();
        BulletEjectAnimation animation = AnimationUtils.createAnimation(bulletEjectPath, BulletEjectAnimation::new);
        AnimationList.enqueue(ModAnimations.BULLET_EJECTION, animation);
    }

    @Override
    public IRenderConfig right() {
        return IRenderConfig.empty();
    }

    @Override
    public IRenderConfig left() {
        return IRenderConfig.empty();
    }

    @Override
    public boolean disableVanillaAnimations() {
        return true;
    }

    public float getOpticalRecoilXY() {
        return 1.0f;
    }

    public float getOpticalRecoilZ() {
        return 1.0f;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - this.getDurability(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        float damage = this.getDurability(stack);
        return GunItem.getDurabilityColor(1.0f - damage);
    }

    public static int getDurabilityColor(float durability) {
        if ((double)durability < 0.4) {
            float f = durability / 0.4f;
            int blue = (int)((1.0f - f) * 255.0f);
            return 0xFF00 | blue;
        }
        float value = Easings.EASE_OUT_CUBIC.ease((durability - 0.4f) / 0.6f);
        int red = (int)(255.0f * value);
        int green = (int)(255.0f * (1.0f - value));
        return red << 16 | green << 8;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDurability(stack) < 1.0f;
    }

    private float getDurability(ItemStack stack) {
        float durabilityMultiplier = this.getDurabilityLimit(stack);
        int stackLimit = stack.func_77958_k();
        int limit = (int)((float)stackLimit * durabilityMultiplier);
        int damage = stack.func_77952_i();
        return (float)(stackLimit - damage) / (float)limit;
    }
}

